/*
 * Decompiled with CFR 0.152.
 */
package org.doublecloud.ws.util;

import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtil {
    public static final Class<?> INT_ARRAY_CLASS = new int[0].getClass();
    public static final Class<?> BYTE_ARRAY_CLASS = new byte[0].getClass();
    public static final Class<?> LONG_ARRAY_CLASS = new long[0].getClass();
    private static final Set<String> PRIMITIVE_TYPES = new HashSet<String>();
    private static String[] BASIC_TYPES;
    private static final Package LANG_PKG;
    private static final Package UTIL_PKG;
    private static String PACKAGE_NAME;
    private static final Map<String, Class<?>> VIM_CLASSES;
    private static Class<?>[] clazzes;
    private static String[] xsdStrs;

    public static boolean isPrimitiveType(String type) {
        return PRIMITIVE_TYPES.contains(type);
    }

    public static boolean isBasicType(String type) {
        for (int i2 = 0; i2 < BASIC_TYPES.length; ++i2) {
            if (!type.startsWith(BASIC_TYPES[i2])) continue;
            return true;
        }
        return false;
    }

    public static boolean isBasicType(Class<?> clazz) {
        Package pkg = clazz.getPackage();
        return pkg == null || pkg == LANG_PKG || pkg == UTIL_PKG;
    }

    public static final Class<?> getVimClass(String type) {
        if (VIM_CLASSES.containsKey(type)) {
            return VIM_CLASSES.get(type);
        }
        try {
            Class<?> clazz = null;
            if (!type.endsWith("[]")) {
                clazz = Class.forName(PACKAGE_NAME + "." + type);
            } else {
                String arrayType = type.substring(0, type.length() - 2);
                clazz = Array.newInstance(TypeUtil.getVimClass(arrayType), 0).getClass();
            }
            VIM_CLASSES.put(type, clazz);
            return clazz;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            return null;
        }
    }

    public static String getXSIType(Object obj) {
        Class<?> type = obj.getClass();
        for (int i2 = 0; i2 < clazzes.length; ++i2) {
            if (type != clazzes[i2]) continue;
            return xsdStrs[i2];
        }
        if (obj instanceof Calendar) {
            return "xsd:dateTime";
        }
        throw new RuntimeException("Unknown data type during serialization:" + type);
    }

    static {
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("double");
        BASIC_TYPES = new String[]{"String", "int", "short", "long", "float", "Float", "byte", "boolean", "Boolean", "Calendar", "double"};
        LANG_PKG = String.class.getPackage();
        UTIL_PKG = Calendar.class.getPackage();
        PACKAGE_NAME = "com.vmware.vim25";
        VIM_CLASSES = new ConcurrentHashMap();
        clazzes = new Class[]{Integer.class, Long.class, Boolean.class, Short.class, Float.class, String.class, Byte.class, Double.class};
        xsdStrs = new String[]{"xsd:int", "xsd:long", "xsd:boolean", "xsd:short", "xsd:float", "xsd:string", "xsd:byte", "xsd:double"};
    }
}

