/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

public class XML11Char {
    public static final byte[] XML11CHARS;
    public static final int MASK_XML11_VALID = 1;
    public static final int MASK_XML11_SPACE = 2;
    public static final int MASK_XML11_NAME_START = 4;
    public static final int MASK_XML11_NAME = 8;
    public static final int MASK_XML11_CONTROL = 16;
    public static final int MASK_XML11_CONTENT = 32;
    public static final int MASK_XML11_NCNAME_START = 64;
    public static final int MASK_XML11_NCNAME = 128;

    public static boolean isXML11Space(int n2) {
        return n2 < 65536 && (XML11CHARS[n2] & 2) != 0;
    }

    public static boolean isXML11Valid(int n2) {
        return n2 < 65536 && (XML11CHARS[n2] & 1) != 0 || 65536 <= n2 && n2 <= 0x10FFFF;
    }

    public static boolean isXML11Invalid(int n2) {
        return !XML11Char.isXML11Valid(n2);
    }

    public static boolean isXML11ValidLiteral(int n2) {
        return n2 < 65536 && (XML11CHARS[n2] & 1) != 0 && (XML11CHARS[n2] & 0x10) == 0 || 65536 <= n2 && n2 <= 0x10FFFF;
    }

    public static boolean isXML11Content(int n2) {
        return n2 < 65536 && (XML11CHARS[n2] & 0x20) != 0 || 65536 <= n2 && n2 <= 0x10FFFF;
    }

    public static boolean isXML11NameStart(int n2) {
        return n2 < 65536 && (XML11CHARS[n2] & 4) != 0 || 65536 <= n2 && n2 < 983040;
    }

    public static boolean isXML11Name(int n2) {
        return n2 < 65536 && (XML11CHARS[n2] & 8) != 0 || n2 >= 65536 && n2 < 983040;
    }

    public static boolean isXML11NCNameStart(int n2) {
        return n2 < 65536 && (XML11CHARS[n2] & 0x40) != 0 || 65536 <= n2 && n2 < 983040;
    }

    public static boolean isXML11NCName(int n2) {
        return n2 < 65536 && (XML11CHARS[n2] & 0x80) != 0 || 65536 <= n2 && n2 < 983040;
    }

    public static boolean isXML11ValidName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c2 = string.charAt(0);
        if (!XML11Char.isXML11NameStart(c2)) {
            return false;
        }
        int n2 = 1;
        while (n2 < string.length()) {
            c2 = string.charAt(n2);
            if (!XML11Char.isXML11Name(c2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isXML11ValidNCName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c2 = string.charAt(0);
        if (!XML11Char.isXML11NCNameStart(c2)) {
            return false;
        }
        int n2 = 1;
        while (n2 < string.length()) {
            c2 = string.charAt(n2);
            if (!XML11Char.isXML11NCName(c2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isXML11ValidNmtoken(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (!XML11Char.isXML11Name(c2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static {
        int n2;
        int n3;
        int n4;
        int n5;
        XML11CHARS = new byte[65536];
        int[] nArray = new int[]{33, 126, 160, 8231, 8233, 55295, 57344, 65533};
        int[] nArray2 = new int[]{9, 10, 13, 32, 133, 8232};
        int[] nArray3 = new int[]{1, 8, 11, 12, 14, 31, 127, 132, 134, 159};
        int[] nArray4 = new int[]{58, 58, 65, 90, 95, 95, 97, 122, 192, 767, 880, 893, 895, 8191, 8204, 8205, 8304, 8591, 11264, 12271, 12289, 55295, 63744, 65533};
        int[] nArray5 = new int[]{45, 45, 46, 46, 48, 57, 183, 183, 768, 879, 8255, 8256};
        int[] nArray6 = new int[]{60, 38, 10, 13, 93};
        int n6 = 0;
        while (n6 < nArray.length) {
            n5 = nArray[n6];
            while (n5 <= nArray[n6 + 1]) {
                int n7 = n5++;
                XML11CHARS[n7] = (byte)(XML11CHARS[n7] | 0x21);
            }
            n6 += 2;
        }
        n5 = 0;
        while (n5 < nArray2.length) {
            int n8 = nArray2[n5];
            XML11CHARS[n8] = (byte)(XML11CHARS[n8] | 0x23);
            ++n5;
        }
        int n9 = 0;
        while (n9 < nArray3.length) {
            n4 = nArray3[n9];
            while (n4 <= nArray3[n9 + 1]) {
                int n10 = n4++;
                XML11CHARS[n10] = (byte)(XML11CHARS[n10] | 0x11);
            }
            n9 += 2;
        }
        n4 = 0;
        while (n4 < nArray4.length) {
            n3 = nArray4[n4];
            while (n3 <= nArray4[n4 + 1]) {
                int n11 = n3++;
                XML11CHARS[n11] = (byte)(XML11CHARS[n11] | 0xCC);
            }
            n4 += 2;
        }
        n3 = 0;
        while (n3 < nArray5.length) {
            n2 = nArray5[n3];
            while (n2 <= nArray5[n3 + 1]) {
                int n12 = n2++;
                XML11CHARS[n12] = (byte)(XML11CHARS[n12] | 0x88);
            }
            n3 += 2;
        }
        XML11CHARS[58] = (byte)(XML11CHARS[58] & 0xFFFFFF3F);
        n2 = 0;
        while (n2 < nArray6.length) {
            int n13 = nArray6[n2];
            XML11CHARS[n13] = (byte)(XML11CHARS[n13] & 0xFFFFFFDF);
            ++n2;
        }
    }
}

