/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.DatatypeException;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.AttributePSVImpl;
import org.apache.xerces.impl.xs.ElementPSVImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSModelImpl;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IDValue;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.KeyRef;
import org.apache.xerces.impl.xs.identity.Selector;
import org.apache.xerces.impl.xs.identity.UniqueOrKey;
import org.apache.xerces.impl.xs.identity.ValueStore;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.psvi.XSObject;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLSchemaValidator
implements XMLComponent,
XMLDocumentFilter,
FieldActivator,
RevalidationHandler {
    private static final boolean DEBUG = false;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String SCHEMA_ELEMENT_DEFAULT = "http://apache.org/xml/features/validation/schema/element-default";
    protected static final String SCHEMA_AUGMENT_PSVI = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String STANDARD_URI_CONFORMANT_FEATURE = "http://apache.org/xml/features/standard-uri-conformant";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://apache.org/xml/features/validation/schema", "http://apache.org/xml/features/validation/dynamic", "http://apache.org/xml/features/validation/schema-full-checking", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/continue-after-fatal-error", "http://apache.org/xml/features/standard-uri-conformant"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, null, null, null, null, null, null};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "http://java.sun.com/xml/jaxp/properties/schemaSource", "http://java.sun.com/xml/jaxp/properties/schemaLanguage"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null, null, null, null, null, null};
    protected static final int ID_CONSTRAINT_NUM = 1;
    protected ElementPSVImpl fCurrentPSVI = new ElementPSVImpl();
    protected final AugmentationsImpl fAugmentations = new AugmentationsImpl();
    protected XMLString fDefaultValue;
    protected boolean fDynamicValidation = false;
    protected boolean fDoValidation = false;
    protected boolean fFullChecking = false;
    protected boolean fNormalizeData = true;
    protected boolean fSchemaElementDefault = true;
    protected boolean fAugPSVI = true;
    private String fSchemaType = null;
    protected boolean fEntityRef = false;
    protected boolean fInCDATA = false;
    protected SymbolTable fSymbolTable;
    protected final XSIErrorReporter fXSIErrorReporter = new XSIErrorReporter();
    protected XMLEntityResolver fEntityResolver;
    protected ValidationManager fValidationManager = null;
    protected ValidationState fValidationState = new ValidationState();
    protected XMLGrammarPool fGrammarPool;
    protected String fExternalSchemas = null;
    protected String fExternalNoNamespaceSchema = null;
    protected Object fJaxpSchemaSource = null;
    final XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();
    protected final XSDDescription fXSDDescription = new XSDDescription();
    protected final Hashtable fLocationPairs = new Hashtable();
    protected String fBaseURI = null;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    static final int INITIAL_STACK_SIZE = 8;
    static final int INC_STACK_SIZE = 8;
    private static final boolean DEBUG_NORMALIZATION = false;
    private final XMLString fEmptyXMLStr = new XMLString(null, 0, -1);
    private static final int BUFFER_SIZE = 20;
    private final XMLString fNormalizedStr = new XMLString();
    private boolean fFirstChunk = true;
    private boolean fTrailing = false;
    private short fWhiteSpace = (short)-1;
    private boolean fUnionType = false;
    final XSGrammarBucket fGrammarBucket;
    final SubstitutionGroupHandler fSubGroupHandler;
    final XMLSchemaLoader fSchemaLoader;
    final XSSimpleType fQNameDV = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("QName");
    final CMNodeFactory nodeFactory = new CMNodeFactory();
    final CMBuilder fCMBuilder = new CMBuilder(this.nodeFactory);
    String fValidationRoot;
    int fSkipValidationDepth;
    int fNFullValidationDepth;
    int fNNoneValidationDepth;
    int fElementDepth;
    boolean fSubElement;
    boolean[] fSubElementStack = new boolean[8];
    XSElementDecl fCurrentElemDecl;
    XSElementDecl[] fElemDeclStack = new XSElementDecl[8];
    boolean fNil;
    boolean[] fNilStack = new boolean[8];
    XSNotationDecl fNotation;
    XSNotationDecl[] fNotationStack = new XSNotationDecl[8];
    XSTypeDefinition fCurrentType;
    XSTypeDefinition[] fTypeStack = new XSTypeDefinition[8];
    XSCMValidator fCurrentCM;
    XSCMValidator[] fCMStack = new XSCMValidator[8];
    int[] fCurrCMState;
    int[][] fCMStateStack = new int[8][];
    boolean fStrictAssess = true;
    boolean[] fStrictAssessStack = new boolean[8];
    final StringBuffer fBuffer = new StringBuffer();
    boolean fAppendBuffer = true;
    boolean fSawText = false;
    boolean[] fSawTextStack = new boolean[8];
    boolean fSawCharacters = false;
    boolean[] fStringContent = new boolean[8];
    boolean fSawChildren = false;
    boolean[] fSawChildrenStack = new boolean[8];
    final QName fTempQName = new QName();
    ValidatedInfo fValidatedInfo = new ValidatedInfo();
    private ValidationState fState4XsiType = new ValidationState();
    private ValidationState fState4ApplyDefault = new ValidationState();
    protected XPathMatcherStack fMatcherStack = new XPathMatcherStack();
    protected ValueStoreCache fValueStoreCache = new ValueStoreCache();

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String string) {
        int n2 = 0;
        while (n2 < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[n2].equals(string)) {
                return FEATURE_DEFAULTS[n2];
            }
            ++n2;
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        int n2 = 0;
        while (n2 < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[n2].equals(string)) {
                return PROPERTY_DEFAULTS[n2];
            }
            ++n2;
        }
        return null;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fValidationState.setNamespaceSupport(namespaceContext);
        this.fState4XsiType.setNamespaceSupport(namespaceContext);
        this.fState4ApplyDefault.setNamespaceSupport(namespaceContext);
        this.handleStartDocument(xMLLocator, string);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(xMLLocator, string, namespaceContext, augmentations);
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(string, string2, string3, augmentations);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        Augmentations augmentations2 = this.handleStartElement(qName, xMLAttributes, augmentations);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations2);
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        Augmentations augmentations2 = this.handleStartElement(qName, xMLAttributes, augmentations);
        this.fDefaultValue = null;
        if (this.fElementDepth != -2) {
            augmentations2 = this.handleEndElement(qName, augmentations2);
        }
        if (this.fDocumentHandler != null) {
            if (!this.fSchemaElementDefault || this.fDefaultValue == null) {
                this.fDocumentHandler.emptyElement(qName, xMLAttributes, augmentations2);
            } else {
                this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations2);
                this.fDocumentHandler.characters(this.fDefaultValue, null);
                this.fDocumentHandler.endElement(qName, augmentations2);
            }
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        xMLString = this.handleCharacters(xMLString);
        if (this.fDocumentHandler != null) {
            if (this.fNormalizeData && this.fUnionType) {
                if (augmentations != null) {
                    this.fDocumentHandler.characters(this.fEmptyXMLStr, augmentations);
                }
            } else {
                this.fDocumentHandler.characters(xMLString, augmentations);
            }
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.handleIgnorableWhitespace(xMLString);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(xMLString, augmentations);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        this.fDefaultValue = null;
        Augmentations augmentations2 = this.handleEndElement(qName, augmentations);
        if (this.fDocumentHandler != null) {
            if (!this.fSchemaElementDefault || this.fDefaultValue == null) {
                this.fDocumentHandler.endElement(qName, augmentations2);
            } else {
                this.fDocumentHandler.characters(this.fDefaultValue, null);
                this.fDocumentHandler.endElement(qName, augmentations2);
            }
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATA = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATA = false;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA(augmentations);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        this.handleEndDocument();
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument(augmentations);
        }
    }

    public void setBaseURI(String string) {
        this.fBaseURI = string;
    }

    public boolean characterData(String string, Augmentations augmentations) {
        boolean bl = this.fSawText = this.fSawText || string.length() > 0;
        if (this.fNormalizeData && this.fWhiteSpace != -1 && this.fWhiteSpace != 0) {
            this.normalizeWhitespace(string, this.fWhiteSpace == 2);
            this.fBuffer.append(this.fNormalizedStr.ch, this.fNormalizedStr.offset, this.fNormalizedStr.length);
        } else if (this.fAppendBuffer) {
            this.fBuffer.append(string);
        }
        boolean bl2 = true;
        if (this.fCurrentType != null && this.fCurrentType.getTypeCategory() == 13) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
            if (xSComplexTypeDecl.fContentType == 2) {
                int n2 = 0;
                while (n2 < string.length()) {
                    if (!XMLChar.isSpace(string.charAt(n2))) {
                        bl2 = false;
                        this.fSawCharacters = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        this.fFirstChunk = false;
        return bl2;
    }

    public void elementDefault(String string) {
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.fEntityRef = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.textDecl(string, string2, augmentations);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fSawChildren = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(xMLString, augmentations);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fSawChildren = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(string, xMLString, augmentations);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        this.fEntityRef = false;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endGeneralEntity(string, augmentations);
        }
    }

    public XMLSchemaValidator() {
        this.fGrammarBucket = new XSGrammarBucket();
        this.fSubGroupHandler = new SubstitutionGroupHandler(this.fGrammarBucket);
        this.fSchemaLoader = new XMLSchemaLoader(this.fXSIErrorReporter.fErrorReporter, this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder);
        this.fState4XsiType.setExtraChecking(false);
        this.fState4ApplyDefault.setFacetChecking(false);
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fXSIErrorReporter.reset((XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER));
        this.fSchemaLoader.setProperty(ERROR_REPORTER, this.fXSIErrorReporter.fErrorReporter);
        SymbolTable symbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        if (symbolTable != this.fSymbolTable) {
            this.fSchemaLoader.setProperty(SYMBOL_TABLE, symbolTable);
            this.fSymbolTable = symbolTable;
        }
        try {
            this.fDynamicValidation = xMLComponentManager.getFeature(DYNAMIC_VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fDynamicValidation = false;
        }
        if (this.fDynamicValidation) {
            this.fDoValidation = true;
        } else {
            try {
                this.fDoValidation = xMLComponentManager.getFeature(VALIDATION);
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                this.fDoValidation = false;
            }
        }
        if (this.fDoValidation) {
            try {
                this.fDoValidation = xMLComponentManager.getFeature(SCHEMA_VALIDATION);
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                // empty catch block
            }
        }
        try {
            this.fFullChecking = xMLComponentManager.getFeature(SCHEMA_FULL_CHECKING);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fFullChecking = false;
        }
        this.fSchemaLoader.setFeature(SCHEMA_FULL_CHECKING, false);
        try {
            this.fNormalizeData = xMLComponentManager.getFeature(NORMALIZE_DATA);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNormalizeData = false;
        }
        try {
            this.fSchemaElementDefault = xMLComponentManager.getFeature(SCHEMA_ELEMENT_DEFAULT);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fSchemaElementDefault = false;
        }
        try {
            this.fAugPSVI = xMLComponentManager.getFeature(SCHEMA_AUGMENT_PSVI);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fAugPSVI = true;
        }
        try {
            this.fSchemaType = (String)xMLComponentManager.getProperty(JAXP_SCHEMA_LANGUAGE);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fSchemaType = null;
        }
        this.fEntityResolver = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_MANAGER);
        this.fSchemaLoader.setEntityResolver(this.fEntityResolver);
        this.fValidationManager = (ValidationManager)xMLComponentManager.getProperty(VALIDATION_MANAGER);
        this.fValidationManager.addValidationState(this.fValidationState);
        this.fValidationState.setSymbolTable(this.fSymbolTable);
        this.fLocationPairs.clear();
        try {
            this.fExternalSchemas = (String)xMLComponentManager.getProperty(SCHEMA_LOCATION);
            this.fExternalNoNamespaceSchema = (String)xMLComponentManager.getProperty(SCHEMA_NONS_LOCATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fExternalSchemas = null;
            this.fExternalNoNamespaceSchema = null;
        }
        this.fSchemaLoader.setProperty(SCHEMA_LOCATION, this.fExternalSchemas);
        this.fSchemaLoader.setProperty(SCHEMA_NONS_LOCATION, this.fExternalNoNamespaceSchema);
        XMLSchemaLoader.processExternalHints(this.fExternalSchemas, this.fExternalNoNamespaceSchema, this.fLocationPairs, this.fXSIErrorReporter.fErrorReporter);
        try {
            this.fJaxpSchemaSource = xMLComponentManager.getProperty(JAXP_SCHEMA_SOURCE);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fJaxpSchemaSource = null;
        }
        this.fSchemaLoader.setProperty(JAXP_SCHEMA_SOURCE, this.fJaxpSchemaSource);
        this.fResourceIdentifier.clear();
        try {
            this.fGrammarPool = (XMLGrammarPool)xMLComponentManager.getProperty(XMLGRAMMAR_POOL);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fGrammarPool = null;
        }
        this.fSchemaLoader.setProperty(XMLGRAMMAR_POOL, this.fGrammarPool);
        try {
            boolean bl = xMLComponentManager.getFeature(ALLOW_JAVA_ENCODINGS);
            this.fSchemaLoader.setFeature(ALLOW_JAVA_ENCODINGS, bl);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        try {
            boolean bl = xMLComponentManager.getFeature(STANDARD_URI_CONFORMANT_FEATURE);
            this.fSchemaLoader.setFeature(STANDARD_URI_CONFORMANT_FEATURE, bl);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        try {
            boolean bl = xMLComponentManager.getFeature(CONTINUE_AFTER_FATAL_ERROR);
            this.fSchemaLoader.setFeature(CONTINUE_AFTER_FATAL_ERROR, bl);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        this.nodeFactory.reset(xMLComponentManager);
        this.fSchemaLoader.reset();
        this.fCurrentElemDecl = null;
        this.fCurrentCM = null;
        this.fCurrCMState = null;
        this.fSkipValidationDepth = -1;
        this.fNFullValidationDepth = -1;
        this.fNNoneValidationDepth = -1;
        this.fElementDepth = -1;
        this.fSubElement = false;
        this.fEntityRef = false;
        this.fInCDATA = false;
        this.fMatcherStack.clear();
        this.fBaseURI = null;
        this.fState4XsiType.setSymbolTable(symbolTable);
        this.fState4ApplyDefault.setSymbolTable(symbolTable);
    }

    public void startValueScopeFor(IdentityConstraint identityConstraint, int n2) throws XNIException {
        ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(identityConstraint, n2);
        valueStoreBase.startValueScope();
    }

    public XPathMatcher activateField(Field field, int n2) {
        ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(field.getIdentityConstraint(), n2);
        field.setMayMatch(true);
        XPathMatcher xPathMatcher = field.createMatcher(valueStoreBase);
        this.fMatcherStack.addMatcher(xPathMatcher);
        xPathMatcher.startDocumentFragment(this.fSymbolTable);
        return xPathMatcher;
    }

    public void endValueScopeFor(IdentityConstraint identityConstraint, int n2) throws XNIException {
        ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(identityConstraint, n2);
        valueStoreBase.endValueScope();
    }

    private void activateSelectorFor(IdentityConstraint identityConstraint) throws XNIException {
        Selector selector = identityConstraint.getSelector();
        XMLSchemaValidator xMLSchemaValidator = this;
        if (selector == null) {
            return;
        }
        XPathMatcher xPathMatcher = selector.createMatcher(xMLSchemaValidator, this.fElementDepth);
        this.fMatcherStack.addMatcher(xPathMatcher);
        xPathMatcher.startDocumentFragment(this.fSymbolTable);
    }

    void ensureStackCapacity() {
        if (this.fElementDepth == this.fElemDeclStack.length) {
            int n2 = this.fElementDepth + 8;
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.fSubElementStack, 0, blArray, 0, this.fElementDepth);
            this.fSubElementStack = blArray;
            XSElementDecl[] xSElementDeclArray = new XSElementDecl[n2];
            System.arraycopy(this.fElemDeclStack, 0, xSElementDeclArray, 0, this.fElementDepth);
            this.fElemDeclStack = xSElementDeclArray;
            blArray = new boolean[n2];
            System.arraycopy(this.fNilStack, 0, blArray, 0, this.fElementDepth);
            this.fNilStack = blArray;
            XSNotationDecl[] xSNotationDeclArray = new XSNotationDecl[n2];
            System.arraycopy(this.fNotationStack, 0, xSNotationDeclArray, 0, this.fElementDepth);
            this.fNotationStack = xSNotationDeclArray;
            XSTypeDefinition[] xSTypeDefinitionArray = new XSTypeDefinition[n2];
            System.arraycopy(this.fTypeStack, 0, xSTypeDefinitionArray, 0, this.fElementDepth);
            this.fTypeStack = xSTypeDefinitionArray;
            XSCMValidator[] xSCMValidatorArray = new XSCMValidator[n2];
            System.arraycopy(this.fCMStack, 0, xSCMValidatorArray, 0, this.fElementDepth);
            this.fCMStack = xSCMValidatorArray;
            blArray = new boolean[n2];
            System.arraycopy(this.fSawTextStack, 0, blArray, 0, this.fElementDepth);
            this.fSawTextStack = blArray;
            blArray = new boolean[n2];
            System.arraycopy(this.fStringContent, 0, blArray, 0, this.fElementDepth);
            this.fStringContent = blArray;
            blArray = new boolean[n2];
            System.arraycopy(this.fSawChildrenStack, 0, blArray, 0, this.fElementDepth);
            this.fSawChildrenStack = blArray;
            blArray = new boolean[n2];
            System.arraycopy(this.fStrictAssessStack, 0, blArray, 0, this.fElementDepth);
            this.fStrictAssessStack = blArray;
            int[][] nArrayArray = new int[n2][];
            System.arraycopy(this.fCMStateStack, 0, nArrayArray, 0, this.fElementDepth);
            this.fCMStateStack = nArrayArray;
        }
    }

    void handleStartDocument(XMLLocator xMLLocator, String string) {
        this.fValueStoreCache.startDocument();
    }

    void handleEndDocument() {
        this.fValueStoreCache.endDocument();
    }

    XMLString handleCharacters(XMLString xMLString) {
        if (this.fSkipValidationDepth >= 0) {
            return xMLString;
        }
        boolean bl = this.fSawText = this.fSawText || xMLString.length > 0;
        if (this.fNormalizeData && this.fWhiteSpace != -1 && this.fWhiteSpace != 0) {
            this.normalizeWhitespace(xMLString, this.fWhiteSpace == 2);
            xMLString = this.fNormalizedStr;
        }
        if (this.fAppendBuffer) {
            this.fBuffer.append(xMLString.ch, xMLString.offset, xMLString.length);
        }
        if (this.fCurrentType != null && this.fCurrentType.getTypeCategory() == 13) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
            if (xSComplexTypeDecl.fContentType == 2) {
                int n2 = xMLString.offset;
                while (n2 < xMLString.offset + xMLString.length) {
                    if (!XMLChar.isSpace(xMLString.ch[n2])) {
                        this.fSawCharacters = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        this.fFirstChunk = false;
        return xMLString;
    }

    private void normalizeWhitespace(XMLString xMLString, boolean bl) {
        int n2;
        boolean bl2 = bl;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = xMLString.offset + xMLString.length;
        if (this.fNormalizedStr.ch == null || this.fNormalizedStr.ch.length < xMLString.length + 1) {
            this.fNormalizedStr.ch = new char[xMLString.length + 1];
        }
        this.fNormalizedStr.offset = 1;
        this.fNormalizedStr.length = 1;
        int n6 = xMLString.offset;
        while (n6 < n5) {
            char c2 = xMLString.ch[n6];
            if (XMLChar.isSpace(c2)) {
                if (!bl2) {
                    this.fNormalizedStr.ch[this.fNormalizedStr.length++] = 32;
                    bl2 = bl;
                }
                if (!bl3) {
                    n3 = 1;
                }
            } else {
                this.fNormalizedStr.ch[this.fNormalizedStr.length++] = c2;
                bl2 = false;
                bl3 = true;
            }
            ++n6;
        }
        if (bl2) {
            if (this.fNormalizedStr.length > 1) {
                --this.fNormalizedStr.length;
                n4 = 2;
            } else if (n3 != 0 && !bl3) {
                n4 = 2;
            }
        }
        int n7 = n2 = bl ? n3 + n4 : 0;
        if (this.fNormalizedStr.length > 1 && !this.fFirstChunk && this.fWhiteSpace == 2) {
            if (this.fTrailing) {
                this.fNormalizedStr.offset = 0;
                this.fNormalizedStr.ch[0] = 32;
            } else if (n2 == 1 || n2 == 3) {
                this.fNormalizedStr.offset = 0;
                this.fNormalizedStr.ch[0] = 32;
            }
        }
        this.fNormalizedStr.length -= this.fNormalizedStr.offset;
        this.fTrailing = n2 > 1;
    }

    private void normalizeWhitespace(String string, boolean bl) {
        boolean bl2 = bl;
        int n2 = string.length();
        if (this.fNormalizedStr.ch == null || this.fNormalizedStr.ch.length < n2) {
            this.fNormalizedStr.ch = new char[n2];
        }
        this.fNormalizedStr.offset = 0;
        this.fNormalizedStr.length = 0;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (XMLChar.isSpace(c2)) {
                if (!bl2) {
                    this.fNormalizedStr.ch[this.fNormalizedStr.length++] = 32;
                    bl2 = bl;
                }
            } else {
                this.fNormalizedStr.ch[this.fNormalizedStr.length++] = c2;
                bl2 = false;
            }
            ++n3;
        }
        if (bl2 && this.fNormalizedStr.length != 0) {
            --this.fNormalizedStr.length;
        }
    }

    void handleIgnorableWhitespace(XMLString xMLString) {
        if (this.fSkipValidationDepth >= 0) {
            return;
        }
    }

    Augmentations handleStartElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) {
        int n2;
        Object object;
        String string;
        XSObject xSObject;
        if (this.fElementDepth == -1 && this.fValidationManager.isGrammarFound() && this.fSchemaType == null) {
            this.fDynamicValidation = true;
        }
        String string2 = xMLAttributes.getValue(SchemaSymbols.URI_XSI, SchemaSymbols.XSI_SCHEMALOCATION);
        String string3 = xMLAttributes.getValue(SchemaSymbols.URI_XSI, SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION);
        this.storeLocations(string2, string3);
        if (this.fSkipValidationDepth >= 0) {
            ++this.fElementDepth;
            if (this.fAugPSVI) {
                augmentations = this.getEmptyAugs(augmentations);
            }
            return augmentations;
        }
        SchemaGrammar schemaGrammar = this.findSchemaGrammar((short)5, qName.uri, null, qName, xMLAttributes);
        Object object2 = null;
        if (this.fCurrentCM != null) {
            object2 = this.fCurrentCM.oneTransition(qName, this.fCurrCMState, this.fSubGroupHandler);
            if (this.fCurrCMState[0] == -1) {
                xSObject = (XSComplexTypeDecl)this.fCurrentType;
                if (xSObject.fParticle != null) {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{qName.rawname, xSObject.fParticle.toString()});
                } else {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{qName.rawname, "mixed with no element content"});
                }
            }
        }
        this.fXSIErrorReporter.pushContext();
        if (this.fElementDepth != -1) {
            this.ensureStackCapacity();
            this.fSubElementStack[this.fElementDepth] = true;
            this.fSubElement = false;
            this.fElemDeclStack[this.fElementDepth] = this.fCurrentElemDecl;
            this.fNilStack[this.fElementDepth] = this.fNil;
            this.fNotationStack[this.fElementDepth] = this.fNotation;
            this.fTypeStack[this.fElementDepth] = this.fCurrentType;
            this.fStrictAssessStack[this.fElementDepth] = this.fStrictAssess;
            this.fCMStack[this.fElementDepth] = this.fCurrentCM;
            this.fCMStateStack[this.fElementDepth] = this.fCurrCMState;
            this.fSawTextStack[this.fElementDepth] = this.fSawText;
            this.fStringContent[this.fElementDepth] = this.fSawCharacters;
            this.fSawChildrenStack[this.fElementDepth] = this.fSawChildren;
        }
        ++this.fElementDepth;
        this.fCurrentElemDecl = null;
        xSObject = null;
        this.fCurrentType = null;
        this.fStrictAssess = true;
        this.fNil = false;
        this.fNotation = null;
        this.fBuffer.setLength(0);
        this.fSawText = false;
        this.fSawCharacters = false;
        this.fSawChildren = false;
        if (object2 != null) {
            if (object2 instanceof XSElementDecl) {
                this.fCurrentElemDecl = (XSElementDecl)object2;
            } else {
                xSObject = (XSWildcardDecl)object2;
            }
        }
        if (xSObject != null && ((XSWildcardDecl)xSObject).fProcessContents == 2) {
            this.fSkipValidationDepth = this.fElementDepth;
            if (this.fAugPSVI) {
                augmentations = this.getEmptyAugs(augmentations);
            }
            return augmentations;
        }
        if (this.fCurrentElemDecl == null && schemaGrammar != null) {
            this.fCurrentElemDecl = schemaGrammar.getGlobalElementDecl(qName.localpart);
        }
        if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getAbstract()) {
            this.reportSchemaError("cvc-elt.2", new Object[]{qName.rawname});
        }
        if (this.fCurrentElemDecl != null) {
            this.fCurrentType = this.fCurrentElemDecl.fType;
        }
        if ((string = xMLAttributes.getValue(SchemaSymbols.URI_XSI, SchemaSymbols.XSI_TYPE)) != null) {
            this.fCurrentType = this.getAndCheckXsiType(qName, string, xMLAttributes);
        }
        if (this.fCurrentType == null) {
            if (this.fElementDepth == 0) {
                if (this.fDynamicValidation) {
                    if (this.fDocumentSource != null) {
                        this.fDocumentSource.setDocumentHandler(this.fDocumentHandler);
                        if (this.fDocumentHandler != null) {
                            this.fDocumentHandler.setDocumentSource(this.fDocumentSource);
                        }
                        this.fElementDepth = -2;
                        return augmentations;
                    }
                    this.fSkipValidationDepth = this.fElementDepth;
                    if (this.fAugPSVI) {
                        augmentations = this.getEmptyAugs(augmentations);
                    }
                    return augmentations;
                }
                this.fXSIErrorReporter.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "cvc-elt.1", new Object[]{qName.rawname}, (short)1);
            } else if (xSObject != null && ((XSWildcardDecl)xSObject).fProcessContents == 1) {
                this.reportSchemaError("cvc-complex-type.2.4.c", new Object[]{qName.rawname});
            }
            this.fCurrentType = SchemaGrammar.fAnyType;
            this.fStrictAssess = false;
            this.fNFullValidationDepth = this.fElementDepth;
            this.fAppendBuffer = false;
        } else {
            this.fNNoneValidationDepth = this.fElementDepth;
            if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2) {
                this.fAppendBuffer = true;
            } else if (this.fCurrentType.getTypeCategory() == 14) {
                this.fAppendBuffer = true;
            } else {
                object = (XSComplexTypeDecl)this.fCurrentType;
                boolean bl = this.fAppendBuffer = ((XSComplexTypeDecl)object).fContentType == 1;
            }
        }
        if (this.fElementDepth == 0) {
            this.fValidationRoot = qName.rawname;
        }
        if (this.fNormalizeData) {
            this.fFirstChunk = true;
            this.fTrailing = false;
            this.fUnionType = false;
            this.fWhiteSpace = (short)-1;
        }
        if (this.fCurrentType.getTypeCategory() == 13) {
            object = (XSComplexTypeDecl)this.fCurrentType;
            if (((XSComplexTypeDecl)object).getAbstract()) {
                this.reportSchemaError("cvc-type.2", new Object[]{"Element " + qName.rawname + " is declared with a type that is abstract.  Use xsi:type to specify a non-abstract type"});
            }
            if (this.fNormalizeData && ((XSComplexTypeDecl)object).fContentType == 1) {
                if (((XSComplexTypeDecl)object).fXSSimpleType.getVariety() == 3) {
                    this.fUnionType = true;
                } else {
                    try {
                        this.fWhiteSpace = ((XSComplexTypeDecl)object).fXSSimpleType.getWhitespace();
                    }
                    catch (DatatypeException datatypeException) {}
                }
            }
        } else if (this.fNormalizeData) {
            object = (XSSimpleType)this.fCurrentType;
            if (object.getVariety() == 3) {
                this.fUnionType = true;
            } else {
                try {
                    this.fWhiteSpace = object.getWhitespace();
                }
                catch (DatatypeException datatypeException) {
                    // empty catch block
                }
            }
        }
        this.fCurrentCM = null;
        if (this.fCurrentType.getTypeCategory() == 13) {
            this.fCurrentCM = ((XSComplexTypeDecl)this.fCurrentType).getContentModel(this.fCMBuilder);
        }
        this.fCurrCMState = null;
        if (this.fCurrentCM != null) {
            this.fCurrCMState = this.fCurrentCM.startContentModel();
        }
        if ((object = xMLAttributes.getValue(SchemaSymbols.URI_XSI, SchemaSymbols.XSI_NIL)) != null && this.fCurrentElemDecl != null) {
            this.fNil = this.getXsiNil(qName, (String)object);
        }
        XSAttributeGroupDecl xSAttributeGroupDecl = null;
        if (this.fCurrentType.getTypeCategory() == 13) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
            xSAttributeGroupDecl = xSComplexTypeDecl.getAttrGrp();
        }
        this.processAttributes(qName, xMLAttributes, xSAttributeGroupDecl);
        if (xSAttributeGroupDecl != null) {
            this.addDefaultAttributes(qName, xMLAttributes, xSAttributeGroupDecl);
        }
        this.fValueStoreCache.startElement();
        this.fMatcherStack.pushContext();
        if (this.fCurrentElemDecl != null) {
            this.fValueStoreCache.initValueStoresFor(this.fCurrentElemDecl);
            int n3 = this.fCurrentElemDecl.fIDCPos;
            n2 = 0;
            while (n2 < n3) {
                if (this.fCurrentElemDecl.fIDConstraints[n2].getCategory() == 2) break;
                this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[n2]);
                ++n2;
            }
            int n4 = n2;
            while (n4 < n3) {
                this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[n4]);
                ++n4;
            }
        }
        int n5 = this.fMatcherStack.getMatcherCount();
        n2 = 0;
        while (n2 < n5) {
            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n2);
            xPathMatcher.startElement(qName, xMLAttributes, this.fCurrentElemDecl);
            ++n2;
        }
        if (this.fAugPSVI) {
            augmentations = this.getEmptyAugs(augmentations);
            this.fCurrentPSVI.fValidationContext = this.fValidationRoot;
            this.fCurrentPSVI.fDeclaration = this.fCurrentElemDecl;
            this.fCurrentPSVI.fTypeDecl = this.fCurrentType;
            this.fCurrentPSVI.fNotation = this.fNotation;
        }
        return augmentations;
    }

    Augmentations handleEndElement(QName qName, Augmentations augmentations) {
        XPathMatcher xPathMatcher;
        Object object;
        if (this.fSkipValidationDepth >= 0) {
            if (this.fSkipValidationDepth == this.fElementDepth && this.fSkipValidationDepth > 0) {
                this.fNFullValidationDepth = this.fSkipValidationDepth - 1;
                this.fSkipValidationDepth = -1;
                --this.fElementDepth;
                this.fSubElement = this.fSubElementStack[this.fElementDepth];
                this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
                this.fNil = this.fNilStack[this.fElementDepth];
                this.fNotation = this.fNotationStack[this.fElementDepth];
                this.fCurrentType = this.fTypeStack[this.fElementDepth];
                this.fCurrentCM = this.fCMStack[this.fElementDepth];
                this.fStrictAssess = this.fStrictAssessStack[this.fElementDepth];
                this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
                this.fSawText = this.fSawTextStack[this.fElementDepth];
                this.fSawCharacters = this.fStringContent[this.fElementDepth];
                this.fSawChildren = this.fSawChildrenStack[this.fElementDepth];
            } else {
                --this.fElementDepth;
            }
            if (this.fElementDepth == -1 && this.fFullChecking) {
                XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fXSIErrorReporter.fErrorReporter);
            }
            if (this.fAugPSVI) {
                augmentations = this.getEmptyAugs(augmentations);
            }
            return augmentations;
        }
        this.processElementContent(qName);
        int n2 = this.fMatcherStack.getMatcherCount();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            XPathMatcher xPathMatcher2 = this.fMatcherStack.getMatcherAt(n3);
            xPathMatcher2.endElement(qName, this.fCurrentElemDecl, this.fDefaultValue == null ? this.fValidatedInfo.normalizedValue : this.fCurrentElemDecl.fDefault.normalizedValue);
            --n3;
        }
        if (this.fMatcherStack.size() > 0) {
            this.fMatcherStack.popContext();
        }
        int n4 = this.fMatcherStack.getMatcherCount();
        int n5 = n2 - 1;
        while (n5 >= n4) {
            XPathMatcher xPathMatcher3 = this.fMatcherStack.getMatcherAt(n5);
            if (xPathMatcher3 instanceof Selector.Matcher && (object = ((Selector.Matcher)(xPathMatcher = (Selector.Matcher)xPathMatcher3)).getIdentityConstraint()) != null && ((IdentityConstraint)object).getCategory() != 2) {
                this.fValueStoreCache.transplant((IdentityConstraint)object, ((Selector.Matcher)xPathMatcher).getInitialDepth());
            }
            --n5;
        }
        int n6 = n2 - 1;
        while (n6 >= n4) {
            ValueStoreBase valueStoreBase;
            IdentityConstraint identityConstraint;
            xPathMatcher = this.fMatcherStack.getMatcherAt(n6);
            if (xPathMatcher instanceof Selector.Matcher && (identityConstraint = ((Selector.Matcher)(object = xPathMatcher)).getIdentityConstraint()) != null && identityConstraint.getCategory() == 2 && (valueStoreBase = this.fValueStoreCache.getValueStoreFor(identityConstraint, ((Selector.Matcher)object).getInitialDepth())) != null) {
                valueStoreBase.endDocumentFragment();
            }
            --n6;
        }
        this.fValueStoreCache.endElement();
        xPathMatcher = null;
        if (this.fElementDepth == 0) {
            object = this.fValidationState.checkIDRefID();
            if (object != null) {
                this.reportSchemaError("cvc-id.1", new Object[]{object});
            }
            if (this.fFullChecking) {
                XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fXSIErrorReporter.fErrorReporter);
            }
            this.fValidationState.resetIDTables();
            xPathMatcher = this.fGrammarBucket.getGrammars();
            if (this.fGrammarPool != null) {
                this.fGrammarPool.cacheGrammars("http://www.w3.org/2001/XMLSchema", (Grammar[])xPathMatcher);
            }
            augmentations = this.endElementPSVI(true, (SchemaGrammar[])xPathMatcher, augmentations);
        } else {
            augmentations = this.endElementPSVI(false, (SchemaGrammar[])xPathMatcher, augmentations);
            --this.fElementDepth;
            this.fSubElement = this.fSubElementStack[this.fElementDepth];
            this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
            this.fNil = this.fNilStack[this.fElementDepth];
            this.fNotation = this.fNotationStack[this.fElementDepth];
            this.fCurrentType = this.fTypeStack[this.fElementDepth];
            this.fCurrentCM = this.fCMStack[this.fElementDepth];
            this.fStrictAssess = this.fStrictAssessStack[this.fElementDepth];
            this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
            this.fSawText = this.fSawTextStack[this.fElementDepth];
            this.fSawCharacters = this.fStringContent[this.fElementDepth];
            this.fSawChildren = this.fSawChildrenStack[this.fElementDepth];
            this.fWhiteSpace = (short)-1;
            this.fAppendBuffer = false;
            this.fUnionType = false;
        }
        return augmentations;
    }

    final Augmentations endElementPSVI(boolean bl, SchemaGrammar[] schemaGrammarArray, Augmentations augmentations) {
        if (this.fAugPSVI) {
            augmentations = this.getEmptyAugs(augmentations);
            this.fCurrentPSVI.fDeclaration = this.fCurrentElemDecl;
            this.fCurrentPSVI.fTypeDecl = this.fCurrentType;
            this.fCurrentPSVI.fNotation = this.fNotation;
            this.fCurrentPSVI.fValidationContext = this.fValidationRoot;
            if (this.fElementDepth > this.fNFullValidationDepth) {
                this.fCurrentPSVI.fValidationAttempted = (short)2;
            } else if (this.fElementDepth > this.fNNoneValidationDepth) {
                this.fCurrentPSVI.fValidationAttempted = 0;
            } else {
                this.fCurrentPSVI.fValidationAttempted = 1;
                this.fNFullValidationDepth = this.fNNoneValidationDepth = this.fElementDepth - 1;
            }
            if (this.fDefaultValue != null) {
                this.fCurrentPSVI.fSpecified = true;
            }
            this.fCurrentPSVI.fNil = this.fNil;
            this.fCurrentPSVI.fMemberType = this.fValidatedInfo.memberType;
            this.fCurrentPSVI.fNormalizedValue = this.fValidatedInfo.normalizedValue;
            if (this.fStrictAssess) {
                String[] stringArray = this.fXSIErrorReporter.mergeContext();
                this.fCurrentPSVI.fErrorCodes = stringArray;
                this.fCurrentPSVI.fValidity = (short)(stringArray == null ? 2 : 1);
            } else {
                this.fCurrentPSVI.fValidity = 0;
                this.fXSIErrorReporter.popContext();
            }
            if (bl) {
                this.fCurrentPSVI.fSchemaInformation = new XSModelImpl(schemaGrammarArray);
            }
        }
        return augmentations;
    }

    Augmentations getEmptyAugs(Augmentations augmentations) {
        if (augmentations == null) {
            augmentations = this.fAugmentations;
            augmentations.removeAllItems();
        }
        augmentations.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
        this.fCurrentPSVI.reset();
        return augmentations;
    }

    void storeLocations(String string, String string2) {
        if (string != null && !XMLSchemaLoader.tokenizeSchemaLocationStr(string, this.fLocationPairs)) {
            this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "SchemaLocation", new Object[]{string}, (short)0);
        }
        if (string2 != null) {
            XMLSchemaLoader.LocationArray locationArray = (XMLSchemaLoader.LocationArray)this.fLocationPairs.get(XMLSymbols.EMPTY_STRING);
            if (locationArray == null) {
                locationArray = new XMLSchemaLoader.LocationArray();
                this.fLocationPairs.put(XMLSymbols.EMPTY_STRING, locationArray);
            }
            locationArray.addLocation(string2);
        }
    }

    SchemaGrammar findSchemaGrammar(short s2, String string, QName qName, QName qName2, XMLAttributes xMLAttributes) {
        SchemaGrammar schemaGrammar = null;
        schemaGrammar = this.fGrammarBucket.getGrammar(string);
        if (schemaGrammar == null) {
            this.fXSDDescription.reset();
            this.fXSDDescription.fContextType = s2;
            this.fXSDDescription.fTargetNamespace = string;
            this.fXSDDescription.fEnclosedElementName = qName;
            this.fXSDDescription.fTriggeringComponent = qName2;
            this.fXSDDescription.fAttributes = xMLAttributes;
            if (this.fBaseURI != null) {
                this.fXSDDescription.setBaseSystemId(this.fBaseURI);
            }
            String[] stringArray = null;
            Object v2 = this.fLocationPairs.get(string == null ? XMLSymbols.EMPTY_STRING : string);
            if (v2 != null) {
                stringArray = ((XMLSchemaLoader.LocationArray)v2).getLocationArray();
            }
            if (stringArray != null && stringArray.length != 0) {
                this.fXSDDescription.fLocationHints = new String[stringArray.length];
                System.arraycopy(stringArray, 0, this.fXSDDescription.fLocationHints, 0, stringArray.length);
            }
            if (this.fGrammarPool != null && (schemaGrammar = (SchemaGrammar)this.fGrammarPool.retrieveGrammar(this.fXSDDescription)) != null && !this.fGrammarBucket.putGrammar(schemaGrammar, true)) {
                this.fXSIErrorReporter.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GrammarConflict", null, (short)0);
                schemaGrammar = null;
            }
            if (schemaGrammar == null) {
                try {
                    XMLInputSource xMLInputSource = XMLSchemaLoader.resolveDocument(this.fXSDDescription, this.fLocationPairs, this.fEntityResolver);
                    schemaGrammar = this.fSchemaLoader.loadSchema(this.fXSDDescription, xMLInputSource, this.fLocationPairs);
                }
                catch (IOException iOException) {
                    this.fXSIErrorReporter.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{this.fXSDDescription.getLocationHints()[0]}, (short)0);
                }
            }
        }
        return schemaGrammar;
    }

    XSTypeDefinition getAndCheckXsiType(QName qName, String string, XMLAttributes xMLAttributes) {
        SchemaGrammar schemaGrammar;
        QName qName2 = null;
        try {
            qName2 = (QName)this.fQNameDV.validate(string, (ValidationContext)this.fValidationState, null);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            this.reportSchemaError(invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs());
            this.reportSchemaError("cvc-elt.4.1", new Object[]{qName.rawname, SchemaSymbols.URI_XSI + "," + SchemaSymbols.XSI_TYPE, string});
            return null;
        }
        XSTypeDefinition xSTypeDefinition = null;
        if (qName2.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA) {
            xSTypeDefinition = SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl(qName2.localpart);
        }
        if (xSTypeDefinition == null && (schemaGrammar = this.findSchemaGrammar((short)7, qName2.uri, qName, qName2, xMLAttributes)) != null) {
            xSTypeDefinition = schemaGrammar.getGlobalTypeDecl(qName2.localpart);
        }
        if (xSTypeDefinition == null) {
            this.reportSchemaError("cvc-elt.4.2", new Object[]{qName.rawname, string});
            return null;
        }
        if (this.fCurrentType != null) {
            short s2 = this.fCurrentElemDecl.fBlock;
            if (this.fCurrentType.getTypeCategory() == 13) {
                s2 = (short)(s2 | ((XSComplexTypeDecl)this.fCurrentType).fBlock);
            }
            if (!XSConstraints.checkTypeDerivationOk(xSTypeDefinition, this.fCurrentType, s2)) {
                this.reportSchemaError("cvc-elt.4.3", new Object[]{qName.rawname, string});
            }
        }
        return xSTypeDefinition;
    }

    boolean getXsiNil(QName qName, String string) {
        if (this.fCurrentElemDecl != null && !this.fCurrentElemDecl.getNillable()) {
            this.reportSchemaError("cvc-elt.3.1", new Object[]{qName.rawname, SchemaSymbols.URI_XSI + "," + SchemaSymbols.XSI_NIL});
        } else {
            String string2 = string.trim();
            if (string2.equals("true") || string2.equals("1")) {
                if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2) {
                    this.reportSchemaError("cvc-elt.3.2.2", new Object[]{qName.rawname, SchemaSymbols.URI_XSI + "," + SchemaSymbols.XSI_NIL});
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void processAttributes(QName var1_1, XMLAttributes var2_2, XSAttributeGroupDecl var3_3) {
        var4_4 = null;
        var5_5 = var2_2.getLength();
        var6_6 = null;
        var7_7 = null;
        var8_8 = this.fCurrentType == null || this.fCurrentType.getTypeCategory() == 14;
        var9_9 = null;
        var10_10 = 0;
        var11_11 = null;
        if (!var8_8) {
            var9_9 = var3_3.getAttributeUses();
            var10_10 = var9_9.getLength();
            var11_11 = var3_3.fAttributeWC;
        }
        var12_12 = 0;
        while (var12_12 < var5_5) {
            block26: {
                block29: {
                    block28: {
                        block27: {
                            block25: {
                                var2_2.getName(var12_12, this.fTempQName);
                                if (this.fAugPSVI) {
                                    var6_6 = var2_2.getAugmentations(var12_12);
                                    var7_7 = (AttributePSVImpl)var6_6.getItem("ATTRIBUTE_PSVI");
                                    if (var7_7 != null) {
                                        var7_7.reset();
                                    } else {
                                        var7_7 = new AttributePSVImpl();
                                        var6_6.putItem("ATTRIBUTE_PSVI", var7_7);
                                    }
                                    var7_7.fValidationContext = this.fValidationRoot;
                                }
                                if (this.fTempQName.uri != SchemaSymbols.URI_XSI) break block25;
                                var13_13 /* !! */  = null;
                                if (this.fTempQName.localpart == SchemaSymbols.XSI_SCHEMALOCATION) {
                                    var13_13 /* !! */  = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_SCHEMALOCATION);
                                } else if (this.fTempQName.localpart == SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION) {
                                    var13_13 /* !! */  = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION);
                                } else if (this.fTempQName.localpart == SchemaSymbols.XSI_NIL) {
                                    var13_13 /* !! */  = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_NIL);
                                } else if (this.fTempQName.localpart == SchemaSymbols.XSI_TYPE) {
                                    var13_13 /* !! */  = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_TYPE);
                                }
                                if (var13_13 /* !! */  == null) break block25;
                                this.processOneAttribute(var1_1, var2_2, var12_12, var13_13 /* !! */ , null, var7_7);
                                break block26;
                            }
                            if (this.fTempQName.rawname == XMLSymbols.PREFIX_XMLNS || this.fTempQName.rawname.startsWith("xmlns:")) break block26;
                            if (!var8_8) break block27;
                            this.reportSchemaError("cvc-type.3.1.1", new Object[]{var1_1.rawname});
                            break block26;
                        }
                        var13_13 /* !! */  = null;
                        var15_15 = 0;
                        while (var15_15 < var10_10) {
                            var14_14 = (XSAttributeUseImpl)var9_9.item(var15_15);
                            if (var14_14.fAttrDecl.fName == this.fTempQName.localpart && var14_14.fAttrDecl.fTargetNamespace == this.fTempQName.uri) {
                                var13_13 /* !! */  = var14_14;
                                break;
                            }
                            ++var15_15;
                        }
                        if (var13_13 /* !! */  != null || var11_11 != null && var11_11.allowNamespace(this.fTempQName.uri)) break block28;
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{var1_1.rawname, this.fTempQName.rawname});
                        break block26;
                    }
                    var16_16 = null;
                    if (var13_13 /* !! */  == null) break block29;
                    var16_16 = var13_13 /* !! */ .fAttrDecl;
                    ** GOTO lbl79
                }
                if (var11_11.fProcessContents == 2) break block26;
                var17_17 = this.findSchemaGrammar((short)6, this.fTempQName.uri, var1_1, this.fTempQName, var2_2);
                if (var17_17 != null) {
                    var16_16 = var17_17.getGlobalAttributeDecl(this.fTempQName.localpart);
                }
                if (var16_16 == null) {
                    if (var11_11.fProcessContents == 1) {
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{var1_1.rawname, this.fTempQName.rawname});
                    }
                } else {
                    if (var16_16.fType.getTypeCategory() == 14 && var16_16.fType.isIDType()) {
                        if (var4_4 != null) {
                            this.reportSchemaError("cvc-complex-type.5.1", new Object[]{var1_1.rawname, var16_16.fName, var4_4});
                        } else {
                            var4_4 = var16_16.fName;
                        }
                    }
lbl79:
                    // 5 sources

                    this.processOneAttribute(var1_1, var2_2, var12_12, var16_16, (XSAttributeUseImpl)var13_13 /* !! */ , var7_7);
                }
            }
            ++var12_12;
        }
        if (!var8_8 && var3_3.fIDAttrName != null && var4_4 != null) {
            this.reportSchemaError("cvc-complex-type.5.2", new Object[]{var1_1.rawname, var4_4, var3_3.fIDAttrName});
        }
    }

    void processOneAttribute(QName qName, XMLAttributes xMLAttributes, int n2, XSAttributeDecl xSAttributeDecl, XSAttributeUseImpl xSAttributeUseImpl, AttributePSVImpl attributePSVImpl) {
        String[] stringArray;
        String string = xMLAttributes.getValue(n2);
        this.fXSIErrorReporter.pushContext();
        XSSimpleType xSSimpleType = xSAttributeDecl.fType;
        Object object = null;
        try {
            object = xSSimpleType.validate(string, (ValidationContext)this.fValidationState, this.fValidatedInfo);
            if (this.fNormalizeData) {
                xMLAttributes.setValue(n2, this.fValidatedInfo.normalizedValue);
            }
            if (xMLAttributes instanceof XMLAttributesImpl) {
                stringArray = (XMLAttributesImpl)xMLAttributes;
                boolean bl = this.fValidatedInfo.memberType != null ? this.fValidatedInfo.memberType.isIDType() : xSSimpleType.isIDType();
                stringArray.setSchemaId(n2, bl);
            }
            if (xSSimpleType.getVariety() == 1 && xSSimpleType.getPrimitiveKind() == 19) {
                stringArray = (QName)object;
                SchemaGrammar schemaGrammar = this.fGrammarBucket.getGrammar(stringArray.uri);
                if (schemaGrammar != null) {
                    this.fNotation = schemaGrammar.getGlobalNotationDecl(stringArray.localpart);
                }
            }
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            this.reportSchemaError(invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs());
            this.reportSchemaError("cvc-attribute.3", new Object[]{qName.rawname, this.fTempQName.rawname, string});
        }
        if (object != null && xSAttributeDecl.getConstraintType() == 2 && !object.equals(xSAttributeDecl.fDefault.actualValue)) {
            this.reportSchemaError("cvc-attribute.4", new Object[]{qName.rawname, this.fTempQName.rawname, string});
        }
        if (object != null && xSAttributeUseImpl != null && xSAttributeUseImpl.fConstraintType == 2 && !object.equals(xSAttributeUseImpl.fDefault.actualValue)) {
            this.reportSchemaError("cvc-complex-type.3.1", new Object[]{qName.rawname, this.fTempQName.rawname, string});
        }
        if (this.fAugPSVI) {
            attributePSVImpl.fDeclaration = xSAttributeDecl;
            if (xSAttributeDecl != null && xSAttributeDecl.fDefault != null) {
                attributePSVImpl.fSchemaDefault = xSAttributeDecl.fDefault.toString();
            }
            attributePSVImpl.fTypeDecl = xSSimpleType;
            attributePSVImpl.fMemberType = this.fValidatedInfo.memberType;
            attributePSVImpl.fNormalizedValue = this.fValidatedInfo.normalizedValue;
            attributePSVImpl.fValidationAttempted = (short)2;
            stringArray = this.fXSIErrorReporter.mergeContext();
            attributePSVImpl.fErrorCodes = stringArray;
            attributePSVImpl.fValidity = (short)(stringArray == null ? 2 : 1);
        }
    }

    void addDefaultAttributes(QName qName, XMLAttributes xMLAttributes, XSAttributeGroupDecl xSAttributeGroupDecl) {
        XSObjectList xSObjectList = xSAttributeGroupDecl.getAttributeUses();
        int n2 = xSObjectList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            boolean bl;
            XSAttributeUseImpl xSAttributeUseImpl = (XSAttributeUseImpl)xSObjectList.item(n3);
            XSAttributeDecl xSAttributeDecl = xSAttributeUseImpl.fAttrDecl;
            short s2 = xSAttributeUseImpl.fConstraintType;
            ValidatedInfo validatedInfo = xSAttributeUseImpl.fDefault;
            if (s2 == 0) {
                s2 = xSAttributeDecl.getConstraintType();
                validatedInfo = xSAttributeDecl.fDefault;
            }
            boolean bl2 = bl = xMLAttributes.getValue(xSAttributeDecl.fTargetNamespace, xSAttributeDecl.fName) != null;
            if (xSAttributeUseImpl.fUse == 1 && !bl) {
                this.reportSchemaError("cvc-complex-type.4", new Object[]{qName.rawname, xSAttributeDecl.fName});
            }
            if (!bl && s2 != 0) {
                Object object;
                QName qName2 = new QName(null, xSAttributeDecl.fName, xSAttributeDecl.fName, xSAttributeDecl.fTargetNamespace);
                String string = validatedInfo != null ? validatedInfo.stringValue() : "";
                int n4 = xMLAttributes.addAttribute(qName2, "CDATA", string);
                if (xMLAttributes instanceof XMLAttributesImpl) {
                    object = (XMLAttributesImpl)xMLAttributes;
                    boolean bl3 = validatedInfo != null && validatedInfo.memberType != null ? validatedInfo.memberType.isIDType() : xSAttributeDecl.fType.isIDType();
                    ((XMLAttributesImpl)object).setSchemaId(n4, bl3);
                }
                if (this.fAugPSVI) {
                    object = xMLAttributes.getAugmentations(n4);
                    AttributePSVImpl attributePSVImpl = new AttributePSVImpl();
                    object.putItem("ATTRIBUTE_PSVI", attributePSVImpl);
                    attributePSVImpl.fDeclaration = xSAttributeDecl;
                    attributePSVImpl.fTypeDecl = xSAttributeDecl.fType;
                    attributePSVImpl.fMemberType = validatedInfo.memberType;
                    attributePSVImpl.fNormalizedValue = string;
                    attributePSVImpl.fSchemaDefault = string;
                    attributePSVImpl.fValidationContext = this.fValidationRoot;
                    attributePSVImpl.fValidity = (short)2;
                    attributePSVImpl.fValidationAttempted = (short)2;
                    attributePSVImpl.fSpecified = true;
                }
            }
            ++n3;
        }
    }

    void processElementContent(QName qName) {
        int n2;
        Object object;
        if (!(this.fCurrentElemDecl == null || this.fCurrentElemDecl.fDefault == null || this.fSawText || this.fSubElement || this.fNil)) {
            object = this.fCurrentElemDecl.fDefault.stringValue();
            n2 = ((String)object).length();
            if (this.fNormalizedStr.ch == null || this.fNormalizedStr.ch.length < n2) {
                this.fNormalizedStr.ch = new char[n2];
            }
            ((String)object).getChars(0, n2, this.fNormalizedStr.ch, 0);
            this.fNormalizedStr.offset = 0;
            this.fNormalizedStr.length = n2;
            this.fDefaultValue = this.fNormalizedStr;
        }
        this.fValidatedInfo.normalizedValue = null;
        if (this.fNil && (this.fSubElement || this.fSawText)) {
            this.reportSchemaError("cvc-elt.3.2.1", new Object[]{qName.rawname, SchemaSymbols.URI_XSI + "," + SchemaSymbols.XSI_NIL});
        }
        this.fValidatedInfo.reset();
        if (!(this.fCurrentElemDecl == null || this.fCurrentElemDecl.getConstraintType() == 0 || this.fSubElement || this.fSawText || this.fNil)) {
            if (this.fCurrentType != this.fCurrentElemDecl.fType && XSConstraints.ElementDefaultValidImmediate(this.fCurrentType, this.fCurrentElemDecl.fDefault.stringValue(), this.fState4XsiType, null) == null) {
                this.reportSchemaError("cvc-elt.5.1.1", new Object[]{qName.rawname, this.fCurrentType.getName(), this.fCurrentElemDecl.fDefault.stringValue()});
            }
            this.elementLocallyValidType(qName, this.fCurrentElemDecl.fDefault.stringValue());
        } else {
            object = this.elementLocallyValidType(qName, this.fBuffer);
            if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2 && !this.fNil) {
                String string = this.fBuffer.toString();
                if (this.fSubElement) {
                    this.reportSchemaError("cvc-elt.5.2.2.1", new Object[]{qName.rawname});
                }
                if (this.fCurrentType.getTypeCategory() == 13) {
                    XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
                    if (xSComplexTypeDecl.fContentType == 3) {
                        if (!this.fCurrentElemDecl.fDefault.normalizedValue.equals(string)) {
                            this.reportSchemaError("cvc-elt.5.2.2.2.1", new Object[]{qName.rawname, string, this.fCurrentElemDecl.fDefault.normalizedValue});
                        }
                    } else if (xSComplexTypeDecl.fContentType == 1 && object != null && !object.equals(this.fCurrentElemDecl.fDefault.actualValue)) {
                        this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{qName.rawname, string, this.fCurrentElemDecl.fDefault.stringValue()});
                    }
                } else if (this.fCurrentType.getTypeCategory() == 14) {
                    XSSimpleType xSSimpleType = (XSSimpleType)this.fCurrentType;
                    if (object != null && !object.equals(this.fCurrentElemDecl.fDefault.actualValue)) {
                        this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{qName.rawname, string, this.fCurrentElemDecl.fDefault.stringValue()});
                    }
                }
            }
        }
        if (this.fDefaultValue == null && this.fNormalizeData && this.fDocumentHandler != null && this.fUnionType) {
            object = this.fValidatedInfo.normalizedValue;
            if (object == null) {
                object = this.fBuffer.toString();
            }
            n2 = ((String)object).length();
            if (this.fNormalizedStr.ch == null || this.fNormalizedStr.ch.length < n2) {
                this.fNormalizedStr.ch = new char[n2];
            }
            ((String)object).getChars(0, n2, this.fNormalizedStr.ch, 0);
            this.fNormalizedStr.offset = 0;
            this.fNormalizedStr.length = n2;
            this.fDocumentHandler.characters(this.fNormalizedStr, null);
        }
    }

    Object elementLocallyValidType(QName qName, Object object) {
        if (this.fCurrentType == null) {
            return null;
        }
        Object object2 = null;
        if (this.fCurrentType.getTypeCategory() == 14) {
            if (this.fSubElement) {
                this.reportSchemaError("cvc-type.3.1.2", new Object[]{qName.rawname});
            }
            if (!this.fNil) {
                XSSimpleType xSSimpleType = (XSSimpleType)this.fCurrentType;
                try {
                    if (!this.fNormalizeData || this.fUnionType) {
                        this.fValidationState.setNormalizationRequired(true);
                    }
                    object2 = xSSimpleType.validate(object, (ValidationContext)this.fValidationState, this.fValidatedInfo);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportSchemaError(invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs());
                    this.reportSchemaError("cvc-type.3.1.3", new Object[]{qName.rawname, object});
                }
            }
        } else {
            object2 = this.elementLocallyValidComplexType(qName, object);
        }
        return object2;
    }

    Object elementLocallyValidComplexType(QName qName, Object object) {
        Object object2 = null;
        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
        if (!this.fNil) {
            if (xSComplexTypeDecl.fContentType == 0 && (this.fSubElement || this.fSawText || this.fSawChildren)) {
                this.reportSchemaError("cvc-complex-type.2.1", new Object[]{qName.rawname});
            } else if (xSComplexTypeDecl.fContentType == 1) {
                if (this.fSubElement) {
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{qName.rawname});
                }
                XSSimpleType xSSimpleType = xSComplexTypeDecl.fXSSimpleType;
                try {
                    if (!this.fNormalizeData || this.fUnionType) {
                        this.fValidationState.setNormalizationRequired(true);
                    }
                    object2 = xSSimpleType.validate(object, (ValidationContext)this.fValidationState, this.fValidatedInfo);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportSchemaError(invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs());
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{qName.rawname});
                }
            } else if (xSComplexTypeDecl.fContentType == 2 && this.fSawCharacters) {
                this.reportSchemaError("cvc-complex-type.2.3", new Object[]{qName.rawname});
            }
            if (!(xSComplexTypeDecl.fContentType != 2 && xSComplexTypeDecl.fContentType != 3 || this.fCurrCMState[0] < 0 || this.fCurrentCM.endContentModel(this.fCurrCMState))) {
                this.reportSchemaError("cvc-complex-type.2.4.b", new Object[]{qName.rawname, ((XSParticleDecl)xSComplexTypeDecl.getParticle()).toString()});
            }
        }
        return object2;
    }

    void reportSchemaError(String string, Object[] objectArray) {
        if (this.fDoValidation) {
            this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
        }
    }

    protected class LocalIDKey {
        private IdentityConstraint fId;
        private int fDepth;

        public LocalIDKey(IdentityConstraint identityConstraint, int n2) {
            this.fId = identityConstraint;
            this.fDepth = n2;
        }

        public int hashCode() {
            return this.fId.hashCode() + this.fDepth;
        }

        public boolean equals(Object object) {
            if (object instanceof LocalIDKey) {
                LocalIDKey localIDKey = (LocalIDKey)object;
                return localIDKey.fId == this.fId && localIDKey.fDepth == this.fDepth;
            }
            return false;
        }
    }

    static final class OrderedHashtable
    implements Cloneable {
        private int fSize;
        private Entry[] fEntries = null;

        OrderedHashtable() {
        }

        public int size() {
            return this.fSize;
        }

        public void put(Field field, IDValue iDValue) {
            int n2 = this.indexOf(field);
            if (n2 == -1) {
                this.ensureCapacity(this.fSize);
                n2 = this.fSize++;
                this.fEntries[n2].key = field;
            }
            this.fEntries[n2].value = iDValue;
        }

        public IDValue get(Field field) {
            return this.fEntries[this.indexOf((Field)field)].value;
        }

        public int indexOf(Field field) {
            int n2 = 0;
            while (n2 < this.fSize) {
                if (this.fEntries[n2].key == field) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        public Field keyAt(int n2) {
            return this.fEntries[n2].key;
        }

        public IDValue valueAt(int n2) {
            return this.fEntries[n2].value;
        }

        public void clear() {
            this.fSize = 0;
        }

        private void ensureCapacity(int n2) {
            int n3 = -1;
            int n4 = -1;
            if (this.fEntries == null) {
                n3 = 0;
                n4 = 2;
                this.fEntries = new Entry[n4];
            } else if (this.fEntries.length <= n2) {
                n3 = this.fEntries.length;
                n4 = 2 * n3;
                Entry[] entryArray = new Entry[n4];
                System.arraycopy(this.fEntries, 0, entryArray, 0, n3);
                this.fEntries = entryArray;
            }
            int n5 = n3;
            while (n5 < n4) {
                this.fEntries[n5] = new Entry();
                ++n5;
            }
        }

        public Object clone() {
            OrderedHashtable orderedHashtable = new OrderedHashtable();
            int n2 = 0;
            while (n2 < this.fSize) {
                orderedHashtable.put(this.fEntries[n2].key, this.fEntries[n2].value);
                ++n2;
            }
            return orderedHashtable;
        }

        public String toString() {
            if (this.fSize == 0) {
                return "[]";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            int n2 = 0;
            while (n2 < this.fSize) {
                if (n2 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('{');
                stringBuffer.append(this.fEntries[n2].key);
                stringBuffer.append(',');
                stringBuffer.append(this.fEntries[n2].value);
                stringBuffer.append('}');
                ++n2;
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        public static final class Entry {
            public Field key;
            public IDValue value;
        }
    }

    protected class ValueStoreCache {
        protected final Vector fValueStores = new Vector();
        protected final Hashtable fIdentityConstraint2ValueStoreMap = new Hashtable();
        protected final Stack fGlobalMapStack = new Stack();
        protected final Hashtable fGlobalIDConstraintMap = new Hashtable();

        public void startDocument() throws XNIException {
            this.fValueStores.removeAllElements();
            this.fIdentityConstraint2ValueStoreMap.clear();
            this.fGlobalIDConstraintMap.clear();
            this.fGlobalMapStack.removeAllElements();
        }

        public void startElement() {
            if (this.fGlobalIDConstraintMap.size() > 0) {
                this.fGlobalMapStack.push(this.fGlobalIDConstraintMap.clone());
            } else {
                this.fGlobalMapStack.push(null);
            }
            this.fGlobalIDConstraintMap.clear();
        }

        public void endElement() {
            if (this.fGlobalMapStack.isEmpty()) {
                return;
            }
            Hashtable hashtable = (Hashtable)this.fGlobalMapStack.pop();
            if (hashtable == null) {
                return;
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                IdentityConstraint identityConstraint = (IdentityConstraint)enumeration.nextElement();
                ValueStoreBase valueStoreBase = (ValueStoreBase)hashtable.get(identityConstraint);
                if (valueStoreBase == null) continue;
                ValueStoreBase valueStoreBase2 = (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
                if (valueStoreBase2 == null) {
                    this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase);
                    continue;
                }
                valueStoreBase2.append(valueStoreBase);
            }
        }

        public void initValueStoresFor(XSElementDecl xSElementDecl) {
            IdentityConstraint[] identityConstraintArray = xSElementDecl.fIDConstraints;
            int n2 = xSElementDecl.fIDCPos;
            int n3 = 0;
            while (n3 < n2) {
                switch (identityConstraintArray[n3].getCategory()) {
                    case 3: {
                        UniqueOrKey uniqueOrKey = (UniqueOrKey)identityConstraintArray[n3];
                        LocalIDKey localIDKey = new LocalIDKey(uniqueOrKey, XMLSchemaValidator.this.fElementDepth);
                        UniqueValueStore uniqueValueStore = (UniqueValueStore)this.fIdentityConstraint2ValueStoreMap.get(localIDKey);
                        if (uniqueValueStore == null) {
                            uniqueValueStore = new UniqueValueStore(uniqueOrKey);
                            this.fIdentityConstraint2ValueStoreMap.put(localIDKey, uniqueValueStore);
                        } else {
                            uniqueValueStore.clear();
                        }
                        this.fValueStores.addElement(uniqueValueStore);
                        break;
                    }
                    case 1: {
                        UniqueOrKey uniqueOrKey = (UniqueOrKey)identityConstraintArray[n3];
                        LocalIDKey localIDKey = new LocalIDKey(uniqueOrKey, XMLSchemaValidator.this.fElementDepth);
                        KeyValueStore keyValueStore = (KeyValueStore)this.fIdentityConstraint2ValueStoreMap.get(localIDKey);
                        if (keyValueStore == null) {
                            keyValueStore = new KeyValueStore(uniqueOrKey);
                            this.fIdentityConstraint2ValueStoreMap.put(localIDKey, keyValueStore);
                        } else {
                            keyValueStore.clear();
                        }
                        this.fValueStores.addElement(keyValueStore);
                        break;
                    }
                    case 2: {
                        KeyRef keyRef = (KeyRef)identityConstraintArray[n3];
                        LocalIDKey localIDKey = new LocalIDKey(keyRef, XMLSchemaValidator.this.fElementDepth);
                        KeyRefValueStore keyRefValueStore = (KeyRefValueStore)this.fIdentityConstraint2ValueStoreMap.get(localIDKey);
                        if (keyRefValueStore == null) {
                            keyRefValueStore = new KeyRefValueStore(keyRef, null);
                            this.fIdentityConstraint2ValueStoreMap.put(localIDKey, keyRefValueStore);
                        } else {
                            keyRefValueStore.clear();
                        }
                        this.fValueStores.addElement(keyRefValueStore);
                    }
                }
                ++n3;
            }
        }

        public ValueStoreBase getValueStoreFor(IdentityConstraint identityConstraint, int n2) {
            ValueStoreBase valueStoreBase = (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(new LocalIDKey(identityConstraint, n2));
            return valueStoreBase;
        }

        public ValueStoreBase getGlobalValueStoreFor(IdentityConstraint identityConstraint) {
            return (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
        }

        public void transplant(IdentityConstraint identityConstraint, int n2) {
            ValueStoreBase valueStoreBase = (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(new LocalIDKey(identityConstraint, n2));
            if (identityConstraint.getCategory() == 2) {
                return;
            }
            ValueStoreBase valueStoreBase2 = (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
            if (valueStoreBase2 != null) {
                valueStoreBase2.append(valueStoreBase);
                this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase2);
            } else {
                this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase);
            }
        }

        public void endDocument() {
            int n2 = this.fValueStores.size();
            int n3 = 0;
            while (n3 < n2) {
                ValueStoreBase valueStoreBase = (ValueStoreBase)this.fValueStores.elementAt(n3);
                valueStoreBase.endDocument();
                ++n3;
            }
        }

        public String toString() {
            String string = super.toString();
            int n2 = string.lastIndexOf(36);
            if (n2 != -1) {
                return string.substring(n2 + 1);
            }
            int n3 = string.lastIndexOf(46);
            if (n3 != -1) {
                return string.substring(n3 + 1);
            }
            return string;
        }
    }

    protected class KeyRefValueStore
    extends ValueStoreBase {
        protected ValueStoreBase fKeyValueStore;

        public KeyRefValueStore(KeyRef keyRef, KeyValueStore keyValueStore) {
            super(keyRef);
            this.fKeyValueStore = keyValueStore;
        }

        public void endDocumentFragment() throws XNIException {
            super.endDocumentFragment();
            this.fKeyValueStore = (ValueStoreBase)XMLSchemaValidator.this.fValueStoreCache.fGlobalIDConstraintMap.get(((KeyRef)this.fIdentityConstraint).getKey());
            if (this.fKeyValueStore == null) {
                String string = "KeyRefOutOfScope";
                String string2 = this.fIdentityConstraint.toString();
                XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2});
                return;
            }
            int n2 = this.fValueTuples.size();
            int n3 = 0;
            while (n3 < n2) {
                OrderedHashtable orderedHashtable = (OrderedHashtable)this.fValueTuples.elementAt(n3);
                if (!this.fKeyValueStore.contains(orderedHashtable)) {
                    String string = "KeyNotFound";
                    String string3 = this.toString(orderedHashtable);
                    String string4 = this.fIdentityConstraint.getElementName();
                    String string5 = this.fIdentityConstraint.getName();
                    XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string5, string3, string4});
                }
                ++n3;
            }
        }

        public void endDocument() throws XNIException {
            super.endDocument();
        }
    }

    protected class KeyValueStore
    extends ValueStoreBase {
        public KeyValueStore(UniqueOrKey uniqueOrKey) {
            super(uniqueOrKey);
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws XNIException {
            String string = "DuplicateKey";
            String string2 = this.toString(orderedHashtable);
            String string3 = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2, string3});
        }
    }

    protected class UniqueValueStore
    extends ValueStoreBase {
        public UniqueValueStore(UniqueOrKey uniqueOrKey) {
            super(uniqueOrKey);
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws XNIException {
            String string = "DuplicateUnique";
            String string2 = this.toString(orderedHashtable);
            String string3 = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2, string3});
        }
    }

    protected abstract class ValueStoreBase
    implements ValueStore {
        protected IDValue NOT_AN_IDVALUE = new IDValue("\uffff", null);
        protected IdentityConstraint fIdentityConstraint;
        protected final OrderedHashtable fValues = new OrderedHashtable();
        protected int fValuesCount;
        protected final Vector fValueTuples = new Vector();

        protected ValueStoreBase(IdentityConstraint identityConstraint) {
            this.fIdentityConstraint = identityConstraint;
        }

        public void clear() {
            this.fValuesCount = 0;
            this.fValues.clear();
            this.fValueTuples.removeAllElements();
        }

        public void append(ValueStoreBase valueStoreBase) {
            int n2 = 0;
            while (n2 < valueStoreBase.fValueTuples.size()) {
                OrderedHashtable orderedHashtable = (OrderedHashtable)valueStoreBase.fValueTuples.elementAt(n2);
                if (!this.contains(orderedHashtable)) {
                    this.fValueTuples.addElement(orderedHashtable);
                }
                ++n2;
            }
        }

        public void startValueScope() throws XNIException {
            this.fValuesCount = 0;
            int n2 = this.fIdentityConstraint.getFieldCount();
            int n3 = 0;
            while (n3 < n2) {
                this.fValues.put(this.fIdentityConstraint.getFieldAt(n3), this.NOT_AN_IDVALUE);
                ++n3;
            }
        }

        public void endValueScope() throws XNIException {
            if (this.fValuesCount == 0) {
                if (this.fIdentityConstraint.getCategory() == 1) {
                    String string = "AbsentKeyValue";
                    String string2 = this.fIdentityConstraint.getElementName();
                    XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2});
                }
                return;
            }
            if (this.fValuesCount != this.fIdentityConstraint.getFieldCount()) {
                switch (this.fIdentityConstraint.getCategory()) {
                    case 3: {
                        String string = "UniqueNotEnoughValues";
                        String string3 = this.fIdentityConstraint.getElementName();
                        XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string3});
                        break;
                    }
                    case 1: {
                        String string = "KeyNotEnoughValues";
                        UniqueOrKey uniqueOrKey = (UniqueOrKey)this.fIdentityConstraint;
                        String string4 = this.fIdentityConstraint.getElementName();
                        String string5 = uniqueOrKey.getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string4, string5});
                        break;
                    }
                    case 2: {
                        String string = "KeyRefNotEnoughValues";
                        KeyRef keyRef = (KeyRef)this.fIdentityConstraint;
                        String string6 = this.fIdentityConstraint.getElementName();
                        String string7 = keyRef.getKey().getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string6, string7});
                    }
                }
                return;
            }
        }

        public void endDocumentFragment() throws XNIException {
        }

        public void endDocument() throws XNIException {
        }

        public void reportError(String string, Object[] objectArray) {
            XMLSchemaValidator.this.reportSchemaError(string, objectArray);
        }

        public void addValue(Field field, IDValue iDValue) {
            int n2;
            if (!field.mayMatch()) {
                String string = "FieldMultipleMatch";
                XMLSchemaValidator.this.reportSchemaError(string, new Object[]{field.toString()});
            }
            if ((n2 = this.fValues.indexOf(field)) == -1) {
                String string = "UnknownField";
                XMLSchemaValidator.this.reportSchemaError(string, new Object[]{field.toString()});
                return;
            }
            IDValue iDValue2 = this.fValues.valueAt(n2);
            if (iDValue2.isDuplicateOf(this.NOT_AN_IDVALUE)) {
                ++this.fValuesCount;
            }
            this.fValues.put(field, iDValue);
            if (this.fValuesCount == this.fValues.size()) {
                if (this.contains(this.fValues)) {
                    this.duplicateValue(this.fValues);
                }
                OrderedHashtable orderedHashtable = (OrderedHashtable)this.fValues.clone();
                this.fValueTuples.addElement(orderedHashtable);
            }
        }

        public boolean contains(OrderedHashtable orderedHashtable) {
            int n2 = orderedHashtable.size();
            int n3 = this.fValueTuples.size();
            int n4 = 0;
            while (n4 < n3) {
                block3: {
                    OrderedHashtable orderedHashtable2 = (OrderedHashtable)this.fValueTuples.elementAt(n4);
                    int n5 = 0;
                    while (n5 < n2) {
                        IDValue iDValue;
                        IDValue iDValue2 = orderedHashtable2.valueAt(n5);
                        if (iDValue2.isDuplicateOf(iDValue = orderedHashtable.valueAt(n5))) {
                            ++n5;
                            continue;
                        }
                        break block3;
                    }
                    return true;
                }
                ++n4;
            }
            return false;
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws XNIException {
        }

        protected String toString(OrderedHashtable orderedHashtable) {
            int n2 = orderedHashtable.size();
            if (n2 == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                if (n3 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(orderedHashtable.valueAt(n3));
                ++n3;
            }
            return stringBuffer.toString();
        }

        public String toString() {
            int n2;
            String string = super.toString();
            int n3 = string.lastIndexOf(36);
            if (n3 != -1) {
                string = string.substring(n3 + 1);
            }
            if ((n2 = string.lastIndexOf(46)) != -1) {
                string = string.substring(n2 + 1);
            }
            return string + '[' + this.fIdentityConstraint + ']';
        }
    }

    protected static class XPathMatcherStack {
        protected XPathMatcher[] fMatchers = new XPathMatcher[4];
        protected int fMatchersCount;
        protected IntStack fContextStack = new IntStack();

        public void clear() {
            int n2 = 0;
            while (n2 < this.fMatchersCount) {
                this.fMatchers[n2] = null;
                ++n2;
            }
            this.fMatchersCount = 0;
            this.fContextStack.clear();
        }

        public int size() {
            return this.fContextStack.size();
        }

        public int getMatcherCount() {
            return this.fMatchersCount;
        }

        public void addMatcher(XPathMatcher xPathMatcher) {
            this.ensureMatcherCapacity();
            this.fMatchers[this.fMatchersCount++] = xPathMatcher;
        }

        public XPathMatcher getMatcherAt(int n2) {
            return this.fMatchers[n2];
        }

        public void pushContext() {
            this.fContextStack.push(this.fMatchersCount);
        }

        public void popContext() {
            this.fMatchersCount = this.fContextStack.pop();
        }

        private void ensureMatcherCapacity() {
            if (this.fMatchersCount == this.fMatchers.length) {
                XPathMatcher[] xPathMatcherArray = new XPathMatcher[this.fMatchers.length * 2];
                System.arraycopy(this.fMatchers, 0, xPathMatcherArray, 0, this.fMatchers.length);
                this.fMatchers = xPathMatcherArray;
            }
        }
    }

    protected final class XSIErrorReporter {
        XMLErrorReporter fErrorReporter;
        Vector fErrors = new Vector(8, 8);
        int[] fContext = new int[8];
        int fContextCount;

        protected XSIErrorReporter() {
        }

        public void reset(XMLErrorReporter xMLErrorReporter) {
            this.fErrorReporter = xMLErrorReporter;
            this.fErrors.removeAllElements();
            this.fContextCount = 0;
        }

        public void pushContext() {
            if (!XMLSchemaValidator.this.fAugPSVI) {
                return;
            }
            if (this.fContextCount == this.fContext.length) {
                int n2 = this.fContextCount + 8;
                int[] nArray = new int[n2];
                System.arraycopy(this.fContext, 0, nArray, 0, this.fContextCount);
                this.fContext = nArray;
            }
            this.fContext[this.fContextCount++] = this.fErrors.size();
        }

        public String[] popContext() {
            if (!XMLSchemaValidator.this.fAugPSVI) {
                return null;
            }
            int n2 = this.fContext[--this.fContextCount];
            int n3 = this.fErrors.size() - n2;
            if (n3 == 0) {
                return null;
            }
            String[] stringArray = new String[n3];
            int n4 = 0;
            while (n4 < n3) {
                stringArray[n4] = (String)this.fErrors.elementAt(n2 + n4);
                ++n4;
            }
            this.fErrors.setSize(n2);
            return stringArray;
        }

        public String[] mergeContext() {
            if (!XMLSchemaValidator.this.fAugPSVI) {
                return null;
            }
            int n2 = this.fContext[--this.fContextCount];
            int n3 = this.fErrors.size() - n2;
            if (n3 == 0) {
                return null;
            }
            String[] stringArray = new String[n3];
            int n4 = 0;
            while (n4 < n3) {
                stringArray[n4] = (String)this.fErrors.elementAt(n2 + n4);
                ++n4;
            }
            return stringArray;
        }

        public void reportError(String string, String string2, Object[] objectArray, short s2) throws XNIException {
            this.fErrorReporter.reportError(string, string2, objectArray, s2);
            this.fErrors.addElement(string2);
        }

        public void reportError(XMLLocator xMLLocator, String string, String string2, Object[] objectArray, short s2) throws XNIException {
            this.fErrorReporter.reportError(xMLLocator, string, string2, objectArray, s2);
            this.fErrors.addElement(string2);
        }
    }
}

