/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.MimeTypeParseException;

public class MimeTypeParameterList {
    private Hashtable parameters = new Hashtable();
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String string) throws MimeTypeParseException {
        this.parse(string);
    }

    protected void parse(String string) throws MimeTypeParseException {
        char c2;
        if (string == null) {
            return;
        }
        int n2 = string.length();
        if (n2 <= 0) {
            return;
        }
        int n3 = MimeTypeParameterList.skipWhiteSpace(string, 0);
        while (n3 < n2 && (c2 = string.charAt(n3)) == ';') {
            String string2;
            ++n3;
            if ((n3 = MimeTypeParameterList.skipWhiteSpace(string, n3)) >= n2) {
                throw new MimeTypeParseException("Couldn't find parameter name");
            }
            int n4 = n3;
            while (n3 < n2 && MimeTypeParameterList.isTokenChar(string.charAt(n3))) {
                ++n3;
            }
            String string3 = string.substring(n4, n3).toLowerCase();
            if ((n3 = MimeTypeParameterList.skipWhiteSpace(string, n3)) >= n2 || string.charAt(n3) != '=') {
                throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            }
            ++n3;
            if ((n3 = MimeTypeParameterList.skipWhiteSpace(string, n3)) >= n2) {
                throw new MimeTypeParseException("Couldn't find a value for parameter named " + string3);
            }
            c2 = string.charAt(n3);
            if (c2 == '\"') {
                if (++n3 >= n2) {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                n4 = n3;
                while (n3 < n2) {
                    c2 = string.charAt(n3);
                    if (c2 == '\"') break;
                    if (c2 == '\\') {
                        ++n3;
                    }
                    ++n3;
                }
                if (c2 != '\"') {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                string2 = MimeTypeParameterList.unquote(string.substring(n4, n3));
                ++n3;
            } else if (MimeTypeParameterList.isTokenChar(c2)) {
                n4 = n3;
                while (n3 < n2 && MimeTypeParameterList.isTokenChar(string.charAt(n3))) {
                    ++n3;
                }
                string2 = string.substring(n4, n3);
            } else {
                throw new MimeTypeParseException("Unexpected character encountered at index " + n3);
            }
            this.parameters.put(string3, string2);
            n3 = MimeTypeParameterList.skipWhiteSpace(string, n3);
        }
        if (n3 < n2) {
            throw new MimeTypeParseException("More characters encountered in input than expected.");
        }
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String get(String string) {
        return (String)this.parameters.get(string.trim().toLowerCase());
    }

    public void set(String string, String string2) {
        this.parameters.put(string.trim().toLowerCase(), string2);
    }

    public void remove(String string) {
        this.parameters.remove(string.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return this.parameters.keys();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(this.parameters.size() * 16);
        Enumeration enumeration = this.parameters.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append("; ");
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(MimeTypeParameterList.quote((String)this.parameters.get(string)));
        }
        return stringBuffer.toString();
    }

    private static boolean isTokenChar(char c2) {
        return c2 > ' ' && c2 < '\u007f' && TSPECIALS.indexOf(c2) < 0;
    }

    private static int skipWhiteSpace(String string, int n2) {
        int n3 = string.length();
        while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        return n2;
    }

    private static String quote(String string) {
        boolean bl = false;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2 && !bl) {
            bl = !MimeTypeParameterList.isTokenChar(string.charAt(n3));
            ++n3;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.ensureCapacity((int)((double)n2 * 1.5));
            stringBuffer.append('\"');
            int n4 = 0;
            while (n4 < n2) {
                char c2 = string.charAt(n4);
                if (c2 == '\\' || c2 == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
                ++n4;
            }
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    private static String unquote(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n2);
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (!bl && c2 != '\\') {
                stringBuffer.append(c2);
            } else if (bl) {
                stringBuffer.append(c2);
                bl = false;
            } else {
                bl = true;
            }
            ++n3;
        }
        return stringBuffer.toString();
    }
}

